Attribute VB_Name = "EnPorterAlgo"
Public sWord As String, StemSteps(51, 1) As String, ListOfExceptions As String, irrVerbs As String
Option Explicit
Function TestEnStemmer()
Dim iLng As Long, Z1() As String, Z2() As String
Z1 = Split("caresses,flies,dies,mules,denied,died,agreed,owned,humbled,sized,meeting,stating,siezing,itemization,sensational,traditional,reference,colonizer,plotted", ",")
Z2 = Split("caress,fli,di,mule,deni,di,agre,own,humbl,size,meet,state,siez,item,sensat,tradit,refer,colon,plot", ",")

For iLng = 0 To UBound(Z1)
    If EnStemmer(Z1(iLng)) <> Z2(iLng) Then MsgBox "Error: " + Z1(iLng) + " -> " + Z2(iLng)
Next
End Function
Public Function EnStemmer(sWord As String) As String
'Er2
'returns a stem for an English word. WARNING: sWord must be lower-case

'initialize the array of verifications once
EnStemmer = irregularVerb(sWord)
If LenB(EnStemmer) > 1 Then Exit Function

If LenB(StemSteps(0, 0)) < 2 Then
    Dim iLng As Long, jLng As Long, TheSPlit() As String, sTemp As String
    sTemp = "sses,ss,ies,i,ss,ss,s,,"
    sTemp = sTemp + "ational,ate,tional,tion,enci,ence,anci,ance,izer,ize,bli,ble,alli,al,entli,ent,eli,e,ousli,ous,ization,ize,ation,ate,ator,ate,alism,al,iveness,ive,fulness,ful,ousness,ous,aliti,al,iviti,ive,biliti,ble,logi,log,"
    sTemp = sTemp + "icate,ic,ative,,alize,al,iciti,ic,ical,ic,ful,,ness,,"
    sTemp = sTemp + "al,,ance,,ence,,er,,ic,,able,,ible,,ant,,ement,,ment,,ent,,ion,,ou,,ism,,ate,,iti,,ous,,ive,,ize,,"
    TheSPlit = Split(sTemp, ",")
    jLng = 0
    For iLng = 0 To 100 Step 2
        StemSteps(jLng, 0) = TheSPlit(iLng): StemSteps(jLng, 1) = TheSPlit(iLng + 1)
        jLng = jLng + 1
    Next
End If

If Not EnStemmerException(sWord) Then
    If Len(Trim(sWord)) > 2 Then
        EnStemmerStep1 sWord
        EnStemmerStep2 sWord
        EnStemmerStep3 sWord
        EnStemmerStep4 sWord
        EnStemmerStep5 sWord
    End If
End If

EnStemmer = sWord

End Function

Function EnStemmerException(sWord As String) As Boolean
'Er2
'brute-force treat exceptional forms here, for peace of mind.
Dim iLng As Long, jLng As Long

If LenB(ListOfExceptions) < 4 Then
    ListOfExceptions = ",skis:ski,skies:sky,dying:die,lying:lie,tying:tie,idly:idl,gently:gentl,ugly:ugli,early:earli,only:onli,singly:singl,sky:,news:,howe:,atlas:cosmos:,bias:,andes:,inning:,outing:,canning:,herring:,earring:,proceed:,exceed:,succeed:,"
End If

jLng = InStr(ListOfExceptions, "," + sWord + ":")
If jLng > 0 Then
    jLng = InStr(jLng + 1, ListOfExceptions, ":")
    If jLng > 0 Then
        iLng = InStr(jLng + 1, ListOfExceptions, ",")
        If iLng > (jLng + 2) Then sWord = Mid$(ListOfExceptions, jLng + 1, iLng - jLng - 1): EnStemmerException = True
    End If
End If
End Function
Private Function EnStemmerStep1(sWord As String)
'Er2

Dim iLng As Long, TheEnding As String, sTemp As String, IsPassed As Boolean

'Uses the StemStep array 0 to 3

If InstrRev(sWord, "s") = Len(sWord) Then
    For iLng = 0 To 3
        If InStrB(sWord, StemSteps(iLng, 0)) > 0 Then
            If MyEndsWith(sWord, StemSteps(iLng, 0)) Then
                sWord = Left(sWord, Len(sWord) - Len(StemSteps(iLng, 0))) + StemSteps(iLng, 1)
                Exit For
            End If
        End If
    Next
End If

IsPassed = False

If LenB(sWord) > 6 Then
TheEnding = Right$(sWord, 3)
If InStrB("eed", TheEnding) = 1 Then
    iLng = lCountsCounsonants(Left$(sWord, Len(sWord) - 3))
    If iLng > 0 Then
        sWord = Left(sWord, Len(sWord) - 3)
        sWord = sWord + "ee"
    End If
ElseIf InStrB("ed", Mid$(TheEnding, 2)) = 1 Then
    If bContainsVowel(Left$(sWord, Len(sWord) - 2)) Then
        sWord = Left$(sWord, Len(sWord) - 2)
        IsPassed = True
    End If
ElseIf InStrB(TheEnding, "ing") = 1 Then
    If bContainsVowel(Left(sWord, Len(sWord) - 3)) Then
        sWord = Left(sWord, Len(sWord) - 3)
        IsPassed = True
    End If
End If
End If
If IsPassed Then
    If InstrRev(sWord, "at") = Len(sWord) - 1 Then
        sWord = Left$(sWord, Len(sWord) - 2) + "ate"
    ElseIf InstrRev(sWord, "bl") = Len(sWord) - 1 Then
        sWord = Left$(sWord, Len(sWord) - 2) + "ble"
    ElseIf InstrRev(sWord, "iz") = Len(sWord) - 1 Then
        sWord = Left$(sWord, Len(sWord) - 2) + "ize"
    ElseIf bEndsWithDblConsonant(sWord) Then
        If InStrB("lsz", Right$(sWord, 1)) = 0 Then sWord = Left$(sWord, Len(sWord) - 1)
    ElseIf lCountsCounsonants(sWord) = 1 Then
        If bEndsCVC(sWord) Then sWord = sWord + "e"
    End If
End If

If Right$(sWord, 1) = "y" Then
    sTemp = Left$(sWord, Len(sWord) - 1)
    If bContainsVowel(sTemp) Then sWord = Left$(sWord, Len(sWord) - 1) + "i"
End If

End Function

Private Function EnStemmerStep2(sWord As String)
'Er2

If LenB(sWord) > 6 And InStrB("nal,nci,zer,bli,lli,tli,eli,sli,ion,tor,ism,ess,iti,ogi", Right$(sWord, 3)) > 0 Then
    Dim iLng As Long, jLng As Long, sTemp As String
    For iLng = 4 To 24
        If MyEndsWith(sWord, StemSteps(iLng, 0)) Then
            jLng = Len(StemSteps(iLng, 0))
            sTemp = Left$(sWord, Len(sWord) - jLng)
            If lCountsCounsonants(sTemp) > 0 Then
                sWord = sTemp + StemSteps(iLng, 1)
            End If
            Exit For
        End If
    Next
End If

End Function

Private Function EnStemmerStep3(sWord As String)
'Er2

If LenB(sWord) > 6 And InStrB("ate,ive,ize,iti,cal,ful,ess", Right$(sWord, 3)) > 0 Then
    Dim iLng As Long, jLng As Long, sTemp As String

    For iLng = 25 To 31
        If MyEndsWith(sWord, StemSteps(iLng, 0)) Then
            jLng = Len(StemSteps(iLng, 0))
            sTemp = Left$(sWord, Len(sWord) - jLng)
            If lCountsCounsonants(sTemp) > 0 Then sWord = sTemp
            Exit For
        End If
    Next
End If

End Function

Private Function EnStemmerStep4(sWord As String)
'Er2

If LenB(sWord) > 6 And InStrB("al,ce,er,ic,le,nt,nt,on,ou,sm,te,ti,us,ve,ze", Right$(sWord, 2)) > 0 Then
    Dim iLng As Long, jLng As Long, sTemp As String

    For iLng = 32 To 50
        If MyEndsWith(sWord, StemSteps(iLng, 0)) Then
            jLng = Len(StemSteps(iLng, 0))
            sTemp = Left$(sWord, Len(sWord) - jLng)
            If lCountsCounsonants(sTemp) > 1 Then
                If InstrRev(sWord, "ion") = Len(sWord) - 2 Then
                    If InstrRev(sTemp, "s") = Len(sTemp) Or InstrRev(sTemp, "t") = Len(sTemp) Then
                        sWord = sTemp
                    End If
                Else
                    sWord = sTemp
                End If
            End If
            Exit For
        End If
    Next
End If

End Function

Private Function EnStemmerStep5(sWord As String)
'Er2

If InstrRev(sWord, "e") = Len(sWord) Then
    Dim sTemp As String
    
    sTemp = Left$(sWord, Len(sWord) - 1)
    If lCountsCounsonants(sTemp) > 1 Then
        sWord = sTemp
    ElseIf lCountsCounsonants(sTemp) = 1 Then
        If Not bEndsCVC(sTemp) Then sWord = sTemp
    End If
End If

If lCountsCounsonants(sWord) > 1 Then
    If bEndsWithDblConsonant(sWord) And InstrRev(sWord, "l") = Len(sWord) Then sWord = Left$(sWord, Len(sWord) - 1)
End If

End Function

Private Function MyEndsWith(sWord As String, endsWith As String) As Boolean
If LenB(endsWith) < LenB(sWord) Then MyEndsWith = (InstrRev(sWord, endsWith) = Len(sWord) - Len(endsWith) + 1)
End Function

Private Function bContainsVowel(ByVal sWord As String) As Boolean
'Er2
Dim ThePattern As String
If LenB(sWord) < 4 Then Exit Function
ThePattern = sCVCpattern(sWord)
bContainsVowel = (InStr(ThePattern, "v") > 0)
End Function

Private Function bEndsWithDblConsonant(sWord As String) As Boolean
'Er2
Dim LastTwo As String

If LenB(sWord) < 6 Then Exit Function

LastTwo = Right(sWord, 2)
If InStr(LastTwo, Right$(sWord, 1)) = 1 Then
    If InStrB("aa,ee,ii,oo,uu", LastTwo + ",") = 0 Then
        If InStrB(LastTwo, "yy") = 1 Then
            If InStrB("aeiou", Mid$(sWord, Len(sWord) - 3, 1)) > 0 Then bEndsWithDblConsonant = True
        Else
            bEndsWithDblConsonant = True
        End If
    End If
End If
    
End Function

Private Function bEndsCVC(sWord As String) As Boolean
'Er2
Dim pattern As String

If LenB(sWord) < 6 Then Exit Function
    
pattern = sCVCpattern(sWord)
      
If InstrRev(pattern, "cvc") = Len(pattern) - 2 Then bEndsCVC = (InStrB("wxy", Right$(sWord, 1)) = 0)
End Function


Private Function lCountsCounsonants(sWord As String) As Long
'Er2
Dim iLng As Long, pattern As String, TheFlag As Boolean

If LenB(sWord) < 2 Then Exit Function

pattern = sCVCpattern(sWord)
        
For iLng = 1 To Len(pattern)
     If Mid$(pattern, iLng, 1) = "v" Or TheFlag Then
        TheFlag = True
        If Mid$(pattern, iLng, 1) = "c" Then
            lCountsCounsonants = lCountsCounsonants + 1
            TheFlag = False
        End If
     End If
Next

End Function

Private Function sCVCpattern(sWord As String) As String
'Er2
Dim iLng As Long

For iLng = 1 To Len(sWord)
    If InStrB("aeiou", Mid$(sWord, iLng, 1)) > 0 Then
        sCVCpattern = sCVCpattern + "v"
    ElseIf Mid$(sWord, iLng, 1) = "y" Then
        If iLng > 1 Then
            If InStrB("aeiou", Mid$(sWord, iLng - 1, 1)) = 0 Then
                sCVCpattern = sCVCpattern + "v"
            Else
                sCVCpattern = sCVCpattern + "c"
            End If
        Else
            sCVCpattern = sCVCpattern + "c"
        End If
    Else
        sCVCpattern = sCVCpattern + "c"
    End If
Next
End Function

Function irregularVerb(theVerb As String) As String
Dim lngI As Long, lngJ As Long, strT As String
If LenB(irrVerbs) < 4 Then
strT = ",abided,abode:abide,alighted,alit:alight,arose,arisen:arise,awakened,awoke,awoken:awake,backbit,backbitten:backbite,backslid,backslidden:backslide,am,is,are,was,were,been:be,bore,born,borne:bear,beaten:beat,became:become,befell,befallen:befall,begat,begot,begotten:beget,began,begun:begin,beheld:behold,bent:bend,bereaved,bereft:bereave,besought,beseeched:beseech,bestrewed,bestrewn:bestrew,betted:bet,betook,betaken:betake,bethought:bethink,bade,bidden:bid,bound:bind,bit,bitten:bite,bled:bleed,blew,blown:blow,broke,broken:break,bred:breed,brought:bring,broadcasted:broadcast,browbeaten:browbeat,built:build,burned,burnt:burn,busted:bust,bought:buy,caught:catch,chided,chid,chidden:chide,chose,chosen:choose,clapped,clapt:clap,clung:cling,clothed,clad:clothe,colorbred:colorbreed,came:come,crept:creep,crossbred:crossbreed,dared,durst:dare,daydreamed,daydreamt:daydream,dealt:deal,dug:dig,dighted:dight,disproved,disproven:disprove,dove,dived:dive,dived,dove:dive,did,done:do,drew,drawn:draw"
strT = strT + ",dreamed,dreamt:dream,drank,drunk:drink,drove,driven:drive,dwelt,dwelled:dwell,ate,eaten:eat,enwound:enwind,fell,fallen:fall,fed:feed,felt:feel,fought:fight,found:find,fitted:fit,fitted:fit,fled:flee,flung:fling,flew,flown:fly,forbore,forborne:forbear,forbade,forbidden:forbid,fordid,fordone:fordo,forewent,foregone:forego,foreknew,foreknown:foreknow,foreran:forerun,foresaw,foreseen:foresee,foreshowed,foreshown:foreshow,forespoke,forespoken:forespeak,foretold:foretell,forgot,forgotten:forget,forgave,forgiven:forgive,forsook,forsaken:forsake,forswore,forsworn:forswear,froze,frozen:freeze,frostbit,frostbitten:frostbite,gainsaid:gainsay,got,gotten:get,gilded,gilt:gild,gave,given:give,went,gone:go,ground:grind,grew,grown:grow,hagrode,hagridden:hagride,halterbroke,halterbroken:halterbreak,hamstrung:hamstring,hand-fed:hand-feed,handwrote,handwritten:handwrite,hung:hang,hanged,hung:hang,had:have,heard:hear,heaved,hove:heave,hewed,hewn:hew,hid,hidden:hide,held:hold,inbred:inbreed,inlaid:inlay"
strT = strT + ",inputted:input,interbred:interbreed,interlaid:interlay,interwove,interweaved,interwoven:interweave,interwound:interwind,inwove,inweaved,inwoven:inweave,jerry-built:jerry-build,kept:keep,knelt,kneeled:kneel,knitted:knit,knew,known:know,laded,laden:lade,landslid:landslide,laid:lay,led:lead,leaned,leant:lean,leaped,leapt:leap,learned,learnt:learn,left:leave,lent:lend,lay,lain:lie,lit,lighted:light,lost:lose,made:make,meant:mean,met:meet,misbecame:misbecome,misdealt:misdeal,misdid,misdone:misdo,misheard:mishear,mislaid:mislay,misled:mislead,mislearned,mislearnt:mislearn,missaid:missay,missent:missend,misspoke,misspoken:misspeak,misspelled,misspelt:misspell,misspent:misspend,misswore,missworn:misswear,mistook,mistaken:mistake,mistaught:misteach,mistold:mistell,misthought:misthink,misunderstood:misunderstand,miswore,misworn:miswear,miswedded:miswed,miswrote,miswritten:miswrite,mowed,mown:mow,outbred:outbreed,outdid,outdone:outdo,outdrew,outdrawn:outdraw,outdrank,outdrunk:outdrink"
strT = strT + ",outdrove,outdriven:outdrive,outfought:outfight,outflew,outflown:outfly,outgrew,outgrown:outgrow,outlaid:outlay,outleaped,outleapt:outleap,outputted:output,outrode,outridden:outride,outran:outrun,outsaw,outseen:outsee,outsold:outsell,outshined,outshone:outshine,outshot:outshoot,outsang,outsung:outsing,outsat:outsit,outslept:outsleep,outsmelled,outsmelt:outsmell,outspoke,outspoken:outspeak,outsped:outspeed,outspent:outspend,outspun:outspin,outsprang,outsprung:outspring,outstood:outstand,outswore,outsworn:outswear,outswam,outswum:outswim,outtold:outtell,outthought:outthink,outthrew,outthrown:outthrow,outwore,outworn:outwear,outwound:outwind,outwrote,outwritten:outwrite,overbore,overborne,overborn:overbear,overbred:overbreed,overbuilt:overbuild,overbought:overbuy,overcame:overcome,overdid,overdone:overdo,overdrew,overdrawn:overdraw,overdrank,overdrunk:overdrink,overate,overeaten:overeat,overfed:overfeed,overhung:overhang,overheard:overhear,overlaid:overlay,overleaped,overleapt:overleap"
strT = strT + ",overlay,overlain:overlie,overpaid:overpay,overrode,overridden:override,overran:overrun,oversaw,overseen:oversee,oversold:oversell,oversewed,oversewn:oversew,overshot:overshoot,overslept:oversleep,oversowed,oversown:oversow,overspoke,overspoken:overspeak,overspent:overspend,overspilled,overspilt:overspill,overspun:overspin,oversprang,oversprung:overspring,overstood:overstand,overstrewed,overstrewn:overstrew,overstrode,overstridden:overstride,overstruck:overstrike,overtook,overtaken:overtake,overthought:overthink,overthrew,overthrown:overthrow,overwore,overworn:overwear,overwound:overwind,overwrote,overwritten:overwrite,partook,partaken:partake,paid:pay,pleaded,pled:plead,prebuilt:prebuild,predid,predone:predo,premade:premake,prepaid:prepay,presold:presell,preshrank,preshrunk:preshrink,proved,proven:prove,quick-froze,quick-frozen:quick-freeze,quitted:quit,reawoke,reawaken:reawake,rebound:rebind,rebroadcasted:rebroadcast,rebuilt:rebuild,redealt:redeal,redid,redone:redo"
strT = strT + ",redrew,redrawn:redraw,reeved,rove:reeve,refitted:refit,refitted:refit,reground:regrind,regrew,regrown:regrow,rehung:rehang,reheard:rehear,reknitted:reknit,relaid:relay,relearned,relearnt:relearn,relit,relighted:relight,remade:remake,rent,rended:rend,repaid:repay,reran:rerun,resold:resell,resent:resend,resewed,resewn:resew,retook,retaken:retake,retaught:reteach,retore,retorn:retear,retold:retell,rethought:rethink,retrofitted:retrofit,rewoke,rewaked,rewaken:rewake,rewore,reworn:rewear,rewove,reweaved,rewoven:reweave,rewedded:rewed,rewetted:rewet,rewon:rewin,rewound:rewind,rewrote,rewritten:rewrite,rode,ridden:ride,rang,rung:ring,rose,risen:rise,rived,riven:rive,ran:run,sawed,sawn:saw,said:say,saw,seen:see,sought:seek,self-fed:self-feed,self-sowed,self-sown:self-sow,sold:sell,sent:send,sewed,sewn:sew,shook,shaken:shake,shaved,shaven:shave,sheared,shorn:shear,shined,shone:shine,shat,shitted:shit,shoed,shod:shoe,shot:shoot,showed,shown:show,shrank,shrunk:shrink,shrived,shrove,shriven:shrive"
strT = strT + ",sang,sung:sing,sank,sunk:sink,sat:sit,skywrote,skywritten:skywrite,slew,slayed,slain:slay,slept:sleep,slid:slide,slung:sling,slinked,slunk:slink,smelled,smelt:smell,smote,smitten:smite,sneaked,snuck:sneak,sowed,sown:sow,spoke,spoken:speak,sped,speeded:speed,spelled,spelt:spell,spent:spend,spilled,spilt:spill,spun:spin,spat:spit,spoiled,spoilt:spoil,spoon-fed:spoon-feed,sprang,sprung:spring,stall-fed:stall-feed,stood:stand,staved,stove:stave,stole,stolen:steal,stuck:stick,stung:sting,stunk,stank:stink,strewed,strewn:strew,strode,stridden:stride,struck,stricken:strike,struck,stricken:strike,strung:string,stripped,stript:strip,strove,strived,striven:strive,sunburned,sunburnt:sunburn,swore,sworn:swear,sweated:sweat,swept:sweep,swelled,swollen:swell,swam,swum:swim,swung:swing,took,taken:take,taught:teach,tore,torn:tear,told:tell,test-drove,test-driven:test-drive,test-flew,test-flown:test-fly,thought:think,thrived,throve,thriven:thrive,threw,thrown:throw,trod,trodden:tread,troubleshot:troubleshoot"
strT = strT + ",typewrote,typewritten:typewrite,unbore,unborn,unborne:unbear,unbent:unbend,unbound:unbind,unbuilt:unbuild,unclothed,unclad:unclothe,underbought:underbuy,underfed:underfeed,underwent,undergone:undergo,underlaid:underlay,underlay,underlain:underlie,underran:underrun,undersold:undersell,undershot:undershoot,underspent:underspend,understood:understand,undertook,undertaken:undertake,underwrote,underwritten:underwrite,undid,undone:undo,undrew,undrawn:undraw,unfroze,unfrozen:unfreeze,unhung:unhang,unhid,unhidden:unhide,unheld:unhold,unknitted:unknit,unladed,unladen:unlade,unlaid:unlay,unlearned,unlearnt:unlearn,unmade:unmake,unreeved,unrove:unreeve,unsaid:unsay,unsewed,unsewn:unsew,unslung:unsling,unspun:unspin,unstuck:unstick,unstrung:unstring,unswore,unsworn:unswear,untaught:unteach,unthought:unthink,unwove,unweaved,unwoven:unweave,unwound:unwind,unwrote,unwritten:unwrite,upheld:uphold,vexed,vext:vex,woke,waked,woken:wake,waylaid:waylay,wore,worn:wear,wove,weaved,woven:weave,wedded:wed"
irrVerbs = strT + ",wept:weep,wetted:wet,won:win,wound:wind,withdrew,withdrawn:withdraw,withheld:withhold,withstood:withstand,wrung:wring,wrote,written:write"
End If
lngI = InStr(irrVerbs, "," + theVerb + ",")
If lngI = 0 Then lngI = InStr(irrVerbs, "," + theVerb + ":")
If lngI = 0 Then Exit Function
lngI = InStr(lngI, irrVerbs, ":")
If lngI = 0 Then Exit Function
lngJ = InStr(lngI, irrVerbs, ",")
If lngJ < lngI + 2 Then Exit Function
irregularVerb = Mid$(irrVerbs, lngI + 1, lngJ - lngI - 1)
End Function
