Attribute VB_Name = "Dictation"
Dim chrApp As Variant, scrObj As Variant, sTxt() As String

Sub WfDictate()
Dim I As Long, J As Long, L As Long, strT As String, docCaption As String
' Exit if no document is present
If Documents.Count < 1 Or Windows.Count < 1 Then Exit Sub

On Error Resume Next
For Each chrApp In Tasks
    If chrApp.Visible And InStr(chrApp.Name, "Chrome") > 0 Then I = 1: Exit For
Next
If I = 0 Then
    InputBox "Point Chrome to the URL below," + Chr(13) + "set your dictation (target) language.", "Chome was not found", "https://www.google.com/intl/en/chrome/demos/speech.html"
    Exit Sub
End If

If InStr(ActiveWindow.Caption, Chr$(160) + " " + Chr$(174)) > 0 Then
    ActiveWindow.Caption = ActiveDocument.Name
    docCaption = ActiveWindow.Caption + " - Microsoft Word"
    
    'Delete the target segment text, if applicable
    'If ActiveDocument.Bookmarks.Exists("WfTarget") Then
    '    L = ActiveDocument.Bookmarks("WfTarget").Start: Selection.SetRange L, L: Selection.MoveEndUntil Chr$(7) + Chr$(12) + Chr$(13)
    '    strT = Replace(Selection.Text, Chr$(13), "")
    '    If Len(strT) > 0 Then Selection.Delete
    'End If
    
    ' in Chrome, turn mike off
    clickMic chrApp, False
    
    'paste the clipboard bare text at end of document, select; put into variable; delete
    L = Selection.Start: I = Selection.StoryLength
    Selection.SetRange I, I: Selection.InsertParagraphAfter: Selection.Collapse 0
    Selection.PasteSpecial , , , , wdPasteText: Selection.Start = I: strT = Selection.Text
    Selection.Delete
    
    ' massage text into single paragraph, clean text
    strT = Replace(strT, Chr$(11), Chr$(13)): strT = Replace(strT, Chr$(10), ""): strT = Replace(strT, Chr$(13) + Chr$(13), Chr$(13))
    
    'look at every paragraph; get the one that has the dictation
    sTxt = Split(strT, Chr$(13)): I = 0
    If Len(Trim$(sTxt(I))) < 3 Or InStr(1, sTxt(I), "eech API ", 1) > 0 Then I = I + 1
    If Len(Trim$(sTxt(I))) < 3 Or InStr(1, sTxt(I), "on the microphone icon", 1) > 0 Then I = I + 1
    J = InStr(1, sTxt(I), "start", 1): K = InStr(1, sTxt(I), "speak", 1)
    If (J > 0 And J < 4) Or (K > 0 And K < 4) Then I = I + 1
    Selection.SetRange L, L: Selection.InsertAfter Trim$(sTxt(I)): Selection.Collapse 0
Else
    ActiveWindow.Caption = ActiveDocument.Name + Chr$(160) + " " + Chr$(174)
    docCaption = ActiveWindow.Caption + " - Microsoft Word"
    
    ' in Chrome, turn mike on
    clickMic chrApp, True
End If
AppActivate docCaption
End Sub
Function clickMic(chrApp As Variant, turnOn As Long)
Dim micIsON As Long, strT As String, strU As String

On Error Resume Next

If IsEmpty(scrObj) Then Set scrObj = CreateObject("WScript.Shell")

' activate Chrome, select all, copy its content into Word
chrApp.Activate: waitMilliSeconds 5
scrObj.SendKeys "{ESC}^a": waitMilliSeconds 5
scrObj.SendKeys "^c":: waitMilliSeconds 5

L = Selection.Start: I = Selection.StoryLength
Selection.SetRange I, I: Selection.InsertParagraphAfter: Selection.Collapse 0

Selection.PasteSpecial , , , , wdPasteText: Selection.Start = I - 1
strT = Selection.Text: Selection.Delete: Selection.SetRange L, L

' now look at what we have: is the mike on, or off?
strU = "e"
If InStr(1, strT, "speaking") > 0 Then micIsON = False: strU = "speaking"
If InStr(1, strT, "adjust") > 0 Then micIsON = False: strU = "adjust"
If InStr(1, strT, "Speak") > 0 Then micIsON = True: strU = "Speak"

' if the mike is already in the state we want, leave
If micIsON = turnOn Then Exit Function

' now go click the mike to toggle it
sText = Split("{ESC},5,^f,5," + strU + "{ENTER},15,{ESC},5,{TAB},15, ,5,,", ",")
For I = 0 To UBound(sText) Step 2
    If Len(sText(I)) > 0 Then
        scrObj.SendKeys sText(I)
        waitMilliSeconds Val(sText(I + 1))
    End If
Next
End Function
Function waitMilliSeconds(mSeconds As Long)
Dim lTime As Double, lMax As Double
lTime = Timer + (mSeconds / 100): lMax = Timer + 0.5
Do While Timer < lTime And Timer < lMax
    DoEvents
Loop
End Function


